; //------------------ treeXYZNCTadppp ---------------------------
;lights trees: 1 ambient light & 1 directional light & 3 point lights

; //--------------------- Constants -------------------------------

; genral definitions
#define ZERO c5.x
#define ONE c5.y
#define PI c5.z
#define EPSILON c5.w
#define R_MODEL_VERT r0
#define R_MODEL_NORMAL r1

; fog definitions
#define R_VERT_TO_FOG r5
#define R_VERT_TO_INTERSECT r6
#define R_VERT_DISTANCE r7
#define R_INTERSECT_DISTANCE r8
#define IS_ZERO	r9
#define IS_NEG r10
#define R_FOG r11

; lighting definitions
#define R_TEMP r6
#define R_VERT_TO_LIGHT r7
#define R_ATTENUATION r8
#define R_INTENSITY r9
#define R_DIFFUSE r10
#define R_SPECULAR r11

; //--------------------- Version -------------------------------

; vertex shader version 1.1
xvs.1.1

; //--------------- Apply Vertex Weights ------------------------

; calculate wind facrtor 
; ( vertz - threshold ) / ( maxz - threshold )
mul r2, v0, c70
sub r3, r2, c71

; clamp wind factor
max r3.z, r3.z, c5.x

; make wind factor exponential
mul r3.z, r3.z, r3.z

; multiply wind factor by wind magnitude
mad R_MODEL_VERT, r3.zzzz, c72, v0

; move normal
mov R_MODEL_NORMAL, v1

; //------------------- Xform Vertices -----------------------------

;transform vertices by view/projection matrix
m4x4 oPos, R_MODEL_VERT, c0

; //----------------- Calculate Texture UV -------------------------

;copy texture coordinates to output   
mov oT0.xy, v3

; //------------------------ Set Fog -------------------------------

; copy zero to fog value
mov oFog.x, ZERO

; //----------------------- Set Color ------------------------------

mov oD0, ONE